function LensFlare(){

	this.reflections=new Array();
	this.vector=new Array(0,0);
	this.range=new Array(GetScreenWidth(),GetScreenHeight());
	this.power=0;
	this.globalPower=1;

}

LensFlare.prototype.addReflection = function(image,distance,zoom,effect,color){

	this.reflections.push(new Reflection(image,distance,zoom,effect,color));

}

LensFlare.prototype.setFlickering = function (pow){
	this.power=pow
	}

LensFlare.prototype.setGlobalPower = function (pow){

	this.globalPower = pow;
	
}

LensFlare.prototype.blit = function(sourceX,sourceY){
	
		
	this.vector[0] = this.range[0]/2-sourceX;
  this.vector[1] = this.range[1]/2-sourceY;
	
	var vectorlength= Math.sqrt(Math.pow(this.vector[0],2)+Math.pow(this.vector[1],2));
	
	for(var i=0;i<this.reflections.length;i++){
		this.reflections[i].color.alpha= this.globalPower * (255-Math.random()*this.power) * Math.min(1,Math.max(0,(1 - ((vectorlength*this.reflections[i].effect)/((this.range[0]+this.range[1])/2)))));
		this.reflections[i].blit(
			sourceX+this.vector[0]*this.reflections[i].distance,
			sourceY+this.vector[1]*this.reflections[i].distance,
			this.reflections[i].zoom,	this.reflections[i].color
			);
		}

}


///////////////////////////////////

function Reflection(tmpimage,tmpdistance,tmpzoom,tmpeffect,tmpcolor){

	this.image=tmpimage;
	this.distance=tmpdistance;
	this.zoom=tmpzoom;
	this.effect=tmpeffect;
	this.color=tmpcolor;

}

Reflection.prototype.blit = function(x,y,zoom,mask){

	this.image.zoomBlitMask(x-this.image.width*zoom/2,y-this.image.height*zoom/2,zoom,mask);
	
}